# Sito liczb pierwszych:
# https://www.nostarch.com/crackingcodes/ (na licencji BSD).

import math, random


def isPrimeTrialDiv(num):
    # Zwraca True, jeśli num to liczba pierwsza, a w przeciwnym razie zwraca False.

    # Do sprawdzenia pierwszości jest używany algorytm próbnego dzielenia.

    # Wszystkie liczby mniejsze niż 2 nie są liczbami pierwszymi.
    if num < 2:
        return False

    # Sprawdzenie, czy wartość num jest podzielna przez dowolną liczbę aż do pierwiastka kwadratowego num.
    for i in range(2, int(math.sqrt(num)) + 1):
        if num % i == 0:
            return False
    return True


def primeSieve(sieveSize):
    # Zwraca listę liczb pierwszych wygenerowanych
    # za pomocą algorytmu sita Eratostenesa.

    sieve = [True] * sieveSize
    sieve[0] = False  # Liczby 0 i 1 nie są liczbami pierwszymi.
    sieve[1] = False

    # Utworzenie sita Eratostenesa.
    for i in range(2, int(math.sqrt(sieveSize)) + 1):
        pointer = i * 2
        while pointer < sieveSize:
            sieve[pointer] = False
            pointer += i

   # Utworzenie listy liczb pierwszych.
    primes = []
    for i in range(sieveSize):
        if sieve[i] == True:
            primes.append(i)

    return primes

def rabinMiller(num):
    # Zwraca wartość True, jeśli num to liczba pierwsza.
    if num % 2 == 0 or num < 2:
        return False  # Test Rabina-Millera nie działa z parzystymi liczbami całkowitymi.
    if num == 3:
        return True
    s = num - 1
    t = 0
    while s % 2 == 0:
        # Podział s na pół, aż stanie się liczbą nieparzystą (i użycie
        # wartości do ustalenia liczby operacji podziału s).
        s = s // 2
        t += 1
    for trials in range(5):  # Pięciokrotne sprawdzenie wartości num pod kątem pierwszości.
        a = random.randrange(2, num - 1)
        v = pow(a, s, num)
        if v != 1:  # Ta operacja nie jest przeprowadzana, jeśli wartością v jest 1.
            i = 0
            while v != (num - 1):
                if i == t - 1:
                    return False
                else:
                    i = i + 1
                    v = (v ** 2) % num
    return True

# W większości przypadków można szybko sprawdzić, czy num nie jest liczbą pierwszą
# przez podzielenie jej przez kilkadziesiąt pierwszych liczb pierwszych, co jest szybsze
# niż użycie funkcji rabinMiller(), choć nie wykrywa wszystkich liczb złożonych.
LOW_PRIMES = primeSieve(100)


def isPrime(num):
    # Zwraca wartość True, jeśli num to liczba pierwsza; ta funkcja pozwala na szybkie
    # sprawdzenie pierwszości liczby przed wywołaniem funkcji rabinMiller().
    if (num < 2):
        return False  # Liczby 0 i 1 nie są liczbami pierwszymi.
    # Sprawdzenie, czy którakolwiek z małych liczb dzieli się bez reszty przez num.
    for prime in LOW_PRIMES:
        if (num % prime == 0):
            return False
        if (num == prime):
            return True
    # Jeżeli inne metody zawiodą, pierwszość liczby należy sprawdzić za pomocą funkcji rabinMiller().
    return rabinMiller(num)


def generateLargePrime(keysize=1024):
    # Zwraca losowo wybraną liczbę pierwszą, której klucz ma podaną liczbę bitów.
    while True:
        num = random.randrange(2**(keysize-1), 2**(keysize))
        if isPrime(num):
            return num
